/*
 * Decompiled with CFR 0.152.
 */
package skyboy.core.world;

import cpw.mods.fml.relauncher.ReflectionHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldSettings;
import skyboy.core.world.WorldServerShim;

public abstract class WorldServerProxy
extends WorldServerShim {
    protected WorldServer proxiedWorld;

    private static String getWorldName(World world) {
        return world.getWorldInfo().getWorldName();
    }

    private static WorldSettings getWorldSettings(World world) {
        return new WorldSettings(world.getWorldInfo());
    }

    public WorldServerProxy(WorldServer worldServer) {
        super(worldServer.func_73046_m(), worldServer.getSaveHandler(), WorldServerProxy.getWorldName((World)worldServer), worldServer.provider, WorldServerProxy.getWorldSettings((World)worldServer), worldServer.theProfiler);
        this.proxiedWorld = worldServer;
        ReflectionHelper.setPrivateValue(World.class, (Object)((Object)this), (Object)worldServer.perWorldStorage, (String[])new String[]{"perWorldStorage"});
        this.loadedEntityList = worldServer.loadedEntityList;
        this.loadedTileEntityList = worldServer.loadedTileEntityList;
        this.playerEntities = worldServer.playerEntities;
        this.weatherEffects = worldServer.weatherEffects;
        this.rand = worldServer.rand;
        this.mapStorage = worldServer.mapStorage;
        this.villageCollectionObj = worldServer.villageCollectionObj;
        this.isRemote = worldServer.isRemote;
        this.customTeleporters = worldServer.customTeleporters;
        this.cofh_updateProps();
    }

    protected void cofh_updateProps() {
        this.scheduledUpdatesAreImmediate = this.proxiedWorld.scheduledUpdatesAreImmediate;
        this.skylightSubtracted = this.proxiedWorld.skylightSubtracted;
        this.prevRainingStrength = this.proxiedWorld.prevRainingStrength;
        this.rainingStrength = this.proxiedWorld.rainingStrength;
        this.prevThunderingStrength = this.proxiedWorld.prevThunderingStrength;
        this.thunderingStrength = this.proxiedWorld.thunderingStrength;
        this.lastLightningBolt = this.proxiedWorld.lastLightningBolt;
        this.difficultySetting = this.proxiedWorld.difficultySetting;
        this.findingSpawnPoint = this.proxiedWorld.findingSpawnPoint;
        this.theChunkProviderServer = this.proxiedWorld.theChunkProviderServer;
        this.allPlayersSleeping = this.proxiedWorld.allPlayersSleeping;
        this.levelSaving = this.proxiedWorld.levelSaving;
    }
}

